/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.comm;

import com.quantumdata.sct.comm.TEInterfaceConstants;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.util.SCTSelection;
import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SystemConsole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class TEInterface {
    private static TEInterface instance;
    private boolean isSimulateMode;
    public RemoteInstrument m_instrument = null;
    private String m_request;
    private String m_response;
    private String m_query = null;
    private int max_attempts = TEInterfaceConstants.MAXATTEMPTS;
    private char seperator = TEInterfaceConstants.COMMA;
    private char respTerminator = (char)10;
    private Collection inputParameters = null;
    private ArrayList outputParameters;
    private boolean fInitialize = false;
    private int destinationAddress = -1;
    private int logicalAddress = -1;

    public static TEInterface instance() {
        if (instance == null) {
            try {
                instance = new TEInterface();
                instance.initialize();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return instance;
    }

    private TEInterface() {
        this.isSimulateMode = Boolean.getBoolean("com.quantumdata.sct.simulateMode");
    }

    public boolean initialize() throws Exception {
        if (this.isSimulateMode) {
            return true;
        }
        this.fInitialize = false;
        if (this.m_instrument != null) {
            if (this.m_instrument.isConnected()) {
                this.m_instrument.disconnect();
            }
            this.m_instrument = null;
        }
        this.m_instrument = new RemoteInstrument(SCTSelection.instance().getCurrentConnection(), (IQDConsole)new SystemConsole());
        this.m_instrument.connect();
        this.fInitialize = true;
        return this.fInitialize;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void setQuery(String string) {
        this.m_query = string;
    }

    public int getMax_attempts() {
        return this.max_attempts;
    }

    public void setMax_attempts(int n) {
        this.max_attempts = n;
    }

    public char getSeperator() {
        return this.seperator;
    }

    public void setSeperator(char c) {
        this.seperator = c;
    }

    public char getRespTerminator() {
        return this.respTerminator;
    }

    public void setRespTerminator(char c) {
        this.respTerminator = c;
    }

    private String getInputParms() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inputParameters == null || this.inputParameters.isEmpty()) {
            return null;
        }
        for (ParameterVO parameterVO : this.inputParameters) {
            if (parameterVO.getValue() == null || parameterVO.getName().equalsIgnoreCase("response")) continue;
            stringBuffer.append(parameterVO.getValue().trim());
            stringBuffer.append(TEInterfaceConstants.SPACE);
        }
        return stringBuffer.toString();
    }

    public void sendCommand(boolean bl) throws GeneratorException {
        if (this.isSimulateMode) {
            return;
        }
        if (!this.fInitialize) {
            this.m_response = "ERROR: Not initialized";
            return;
        }
        this.m_request = this.m_query;
        if (this.inputParameters != null) {
            this.m_request = this.m_query + TEInterfaceConstants.SPACE + this.getInputParms();
        }
        this.m_request = this.m_request.replaceAll("null", "");
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(this.m_request);
        if (instrumentResponse.isError()) {
            this.m_response = "ERROR: Failed request";
            return;
        }
        this.m_response = instrumentResponse.getResponse();
    }

    public ArrayList scanInstrument() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isSimulateMode) {
            return arrayList;
        }
        this.executeQueryWaitForResponse("*IDN?", TEInterfaceConstants.MAXATTEMPTS);
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_response, ",");
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        return arrayList;
    }

    public String executeQueryWaitForResponse(String string, int n) throws GeneratorException {
        if (this.isSimulateMode) {
            return "Simulate Mode";
        }
        boolean bl = false;
        int n2 = 0;
        this.setQuery(string);
        while (!bl) {
            this.sendCommand(false);
            if (this.m_response.equals(TEInterfaceConstants.PENDING)) {
                if (++n2 < n) {
                    try {
                        Thread.sleep(TEInterfaceConstants.QUERY_RETRY_DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new GeneratorException("Command pending too long");
            }
            bl = true;
        }
        return this.m_response;
    }

    public String sendMessageAndGetResponse() throws GeneratorException {
        if (this.isSimulateMode) {
            return "Simulate Mode";
        }
        if (!this.fInitialize) {
            throw new GeneratorException("Please initialize");
        }
        this.sendCommand(true);
        return this.executeQueryWaitForResponse("CECM?", TEInterfaceConstants.MAXATTEMPTS);
    }

    public int emulate(int n, int n2, int n3, int n4, int n5, int n6, String string) throws GeneratorException {
        if (this.isSimulateMode) {
            return 0;
        }
        this.logicalAddress = 15;
        try {
            String string2 = "CECE " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + n6 + " \"" + string + "\"";
            this.setQuery(string2);
            this.sendCommand(true);
            String string3 = this.executeQueryWaitForResponse("CECE?", TEInterfaceConstants.MAXATTEMPTS);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            boolean bl = false;
            if (stringTokenizer.hasMoreElements() && stringTokenizer.nextToken().equals("LA") && stringTokenizer.hasMoreElements()) {
                try {
                    this.logicalAddress = Integer.parseInt(stringTokenizer.nextToken());
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl) {
                throw new GeneratorException("Bad emulate query response: " + string3);
            }
        }
        catch (GeneratorException generatorException) {
            generatorException.printStackTrace();
            throw generatorException;
        }
        return this.logicalAddress;
    }

    public static boolean validateLogicalAddress(int n) throws CecException {
        if (n < 0 || n > 15) {
            throw new CecException("Value \"" + n + "\" is outside of valid range [0, " + 15 + "] for CEC logical addresses");
        }
        return true;
    }

    public Collection getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(Collection collection) {
        this.inputParameters = collection;
    }

    public ArrayList getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(ArrayList arrayList) {
        this.outputParameters = arrayList;
    }

    public int getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(int n) {
        this.destinationAddress = n;
    }

    public int getLogicalAddress() {
        return this.logicalAddress;
    }

    public void setLogicalAddress(int n) {
        this.logicalAddress = n;
    }

    static class CecException
    extends Exception {
        public CecException(String string) {
            super(string);
        }

        public CecException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    static class GeneratorException
    extends Exception {
        public GeneratorException(String string) {
            super(string);
        }

        public GeneratorException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

